﻿using System;

namespace VIRP.EFR.BO
{
    /// <summary>
    /// Maps to view of: [EFR].[EFR_ICD9_DIAG] and [CRS].[STD_INSTITUTION]
    /// </summary>
    public class RelatedDiagnosticsView
    {
        /// <summary>
        /// [EFR].[EFR_ICD9_DIAG].ICD9DIS_ID
        /// </summary>
        public int ID { get; set; }

        /// <summary>
        /// [EFR].[EFR_ICD9_DIAG].ICD9_CODE
        /// </summary>
        public string ICDCode { get; set; }

        /// <summary>
        /// [EFR].[EFR_ICD9_DIAG].ICD_CODESET
        /// </summary>
        public int ICDCodeSet { get; set; }

        /// <summary>
        /// [EFR].[EFR_ICD9_DIAG].ICD9_CODE_NAME
        /// </summary>
        public string ICDCodeName { get; set; }

        /// <summary>
        /// [EFR].[EFR_ICD9_DIAG].ENCOUNTER_DATETIME
        /// </summary>
        public DateTime? EncounterDate { get; set; }

        /// <summary>
        /// [CRS].[STD_INSTITUTION].STATIONNUMBER
        /// </summary>
        public string SiteCode { get; set; }

        /// <summary>
        /// [CRS].[STD_INSTITUTION].NAME
        /// </summary>
        public string FacilityName { get; set; }
    }
}
